/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.resources.textures;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.textures.SpriteUtils;
import net.mehvahdjukaar.moonlight.api.util.math.colors.RGBColor;
import net.minecraft.class_1011;
import net.minecraft.class_1079;
import net.minecraft.class_1080;
import net.minecraft.class_2960;
import net.minecraft.class_3255;
import net.minecraft.class_3270;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.Nullable;

public class TextureImage
implements AutoCloseable {
    @Nullable
    private final class_1079 metadata;
    private final class_1011 image;
    private final int frameW;
    private final int frameH;
    private final int maxFrames;
    private final int frameScale;

    private TextureImage(class_1011 image, @Nullable class_1079 metadata) {
        this.image = image;
        this.metadata = metadata;
        int imgWidth = this.imageWidth();
        int imgHeight = this.imageHeight();
        this.frameW = metadata == null ? imgWidth : metadata.method_4687(imgWidth);
        this.frameH = metadata == null ? imgHeight : metadata.method_4686(imgWidth);
        this.frameScale = imgWidth / this.frameW;
        int frameScaleHeight = imgHeight / this.frameH;
        this.maxFrames = this.frameScale * frameScaleHeight;
    }

    public void forEachFrame(FramePixelConsumer framePixelConsumer) {
        for (int ind = 0; ind < this.maxFrames; ++ind) {
            int xOff = this.getFrameX(ind);
            int yOff = this.getFrameY(ind);
            for (int x = 0; x < this.frameW; ++x) {
                for (int y = 0; y < this.frameH; ++y) {
                    framePixelConsumer.accept(ind, x + xOff, y + yOff);
                }
            }
        }
    }

    public void toGrayscale() {
        SpriteUtils.grayscaleImage(this.image);
    }

    public RGBColor getAverageColor() {
        return SpriteUtils.averageColor(this.image);
    }

    public int frameWidth() {
        return this.frameW;
    }

    public int frameHeight() {
        return this.frameH;
    }

    public int getFrameX(int frameIndex) {
        return frameIndex % this.frameScale * this.frameW;
    }

    public int getFrameY(int frameIndex) {
        return frameIndex / this.frameScale * this.frameH;
    }

    public class_1011 getImage() {
        return this.image;
    }

    public int framesSize() {
        return this.maxFrames;
    }

    @Nullable
    public class_1079 getMetadata() {
        return this.metadata;
    }

    public TextureImage makeCopy() {
        class_1011 im = new class_1011(this.imageWidth(), this.imageHeight(), false);
        im.method_4317(this.image);
        return new TextureImage(im, this.metadata);
    }

    public TextureImage createAnimationTemplate(int length, class_1079 useDataFrom) {
        ArrayList<class_1080> frameData = new ArrayList<class_1080>();
        useDataFrom.method_33460((i, t) -> frameData.add(new class_1080(i, t)));
        return this.createAnimationTemplate(length, frameData, useDataFrom.method_4684(), useDataFrom.method_4685());
    }

    public TextureImage createAnimationTemplate(int length, List<class_1080> frameData, int frameTime, boolean interpolate) {
        class_1011 im = new class_1011(this.frameWidth(), this.frameHeight() * length, false);
        TextureImage t = new TextureImage(im, new class_1079(frameData, this.frameW, this.frameH, frameTime, interpolate));
        t.forEachFrame((i, x, y) -> {
            int xo = x - t.getFrameX(i);
            int yo = y - t.getFrameY(i);
            t.image.method_4305(x.intValue(), y.intValue(), this.image.method_4315(xo, yo));
        });
        return t;
    }

    public static TextureImage open(class_3300 manager, class_2960 relativePath) throws IOException {
        class_2960 textureLoc = ResType.TEXTURES.getPath(relativePath);
        class_1011 i = SpriteUtils.readImage(manager, textureLoc);
        class_2960 metadataLoc = ResType.MCMETA.getPath(relativePath);
        class_1079 metadata = null;
        Optional res = manager.method_14486(metadataLoc);
        if (res.isPresent()) {
            try (InputStream metadataStream = ((class_3298)res.get()).method_14482();){
                metadata = (class_1079)class_3255.method_14392((class_3270)class_1079.field_5337, (InputStream)metadataStream);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new TextureImage(i, metadata);
    }

    public static TextureImage createNew(int width, int height, @Nullable class_1079 animation) {
        return new TextureImage(new class_1011(width, height, false), animation);
    }

    public static TextureImage of(class_1011 image, @Nullable class_1079 animation) {
        return new TextureImage(image, animation);
    }

    @Override
    public void close() {
        this.image.close();
    }

    public int imageWidth() {
        return this.image.method_4307();
    }

    public int imageHeight() {
        return this.image.method_4323();
    }

    public ImmutableList<class_1011> splitFrames() {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (this.metadata == null) {
            builder.add((Object)this.image);
            return builder.build();
        }
        int imgWidth = this.imageWidth();
        int imgHeight = this.imageHeight();
        int frameW = this.metadata.method_4687(imgWidth);
        int frameH = this.metadata.method_4686(imgWidth);
        int frameScaleWidth = imgWidth / frameW;
        int frameScaleHeight = imgHeight / frameH;
        int maxFrames = frameScaleWidth * frameScaleHeight;
        ArrayList indexList = Lists.newArrayList();
        this.metadata.method_33460((index, time) -> indexList.add(index));
        if (indexList.isEmpty()) {
            for (int l = 0; l < maxFrames; ++l) {
                indexList.add(l);
            }
        }
        if (indexList.size() <= 1) {
            builder.add((Object)this.image);
        } else {
            Iterator iterator = indexList.iterator();
            while (iterator.hasNext()) {
                int index2 = (Integer)iterator.next();
                int xOffset = index2 % frameScaleWidth * frameW;
                int yOffset = index2 / frameScaleWidth * frameH;
                if (index2 < 0 || xOffset + frameW >= imgWidth || yOffset + frameH >= imgHeight) continue;
                class_1011 f = new class_1011(frameW, frameH, false);
                for (int x = 0; x < frameW; ++x) {
                    for (int y = 0; y < frameH; ++y) {
                        f.method_4305(x, y, this.image.method_4315(x + xOffset, y + yOffset));
                    }
                }
                builder.add((Object)f);
            }
        }
        return builder.build();
    }

    @Nullable
    public JsonObject serializeMcMeta() {
        if (this.metadata == null) {
            return null;
        }
        JsonObject obj = new JsonObject();
        JsonObject animation = new JsonObject();
        animation.addProperty("frametime", (Number)this.metadata.method_4684());
        animation.addProperty("interpolate", Boolean.valueOf(this.metadata.method_4685()));
        animation.addProperty("height", (Number)this.metadata.method_4686(this.frameHeight()));
        animation.addProperty("width", (Number)this.metadata.method_4687(this.frameWidth()));
        JsonArray frames = new JsonArray();
        this.metadata.method_33460((i, t) -> {
            if (t != -1) {
                JsonObject o = new JsonObject();
                o.addProperty("time", (Number)t);
                o.addProperty("index", (Number)i);
                frames.add((JsonElement)o);
            } else {
                frames.add((Number)i);
            }
        });
        animation.add("frames", (JsonElement)frames);
        obj.add("animation", (JsonElement)animation);
        return obj;
    }

    public void applyOverlay(TextureImage ... overlays) throws IllegalStateException {
        int width = this.imageWidth();
        int height = this.imageHeight();
        if (Arrays.stream(overlays).anyMatch(n -> n.imageHeight() < height || n.imageWidth() < width)) {
            throw new IllegalStateException("Could not merge images because they had different dimensions");
        }
        for (TextureImage o : overlays) {
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    this.image.method_35624(x, y, o.image.method_4315(x, y));
                }
            }
            o.close();
        }
    }

    public void applyOverlayOnExisting(TextureImage ... overlays) throws IllegalStateException {
        int width = this.imageWidth();
        int height = this.imageHeight();
        if (Arrays.stream(overlays).anyMatch(n -> n.imageHeight() < height || n.imageWidth() < width)) {
            throw new IllegalStateException("Could not merge images because they had different dimensions");
        }
        for (TextureImage o : overlays) {
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    if (class_1011.method_24030((int)this.image.method_4315(x, y)) == 0) continue;
                    this.image.method_35624(x, y, o.image.method_4315(x, y));
                }
            }
            o.close();
        }
    }

    public void removeAlpha(int backgroundColor) {
        for (int x = 0; x < this.image.method_4307(); ++x) {
            for (int y = 0; y < this.image.method_4323(); ++y) {
                int oldValue = this.image.method_4315(x, y);
                int a = class_1011.method_24030((int)oldValue);
                if (a == 0) {
                    this.image.method_4305(x, y, backgroundColor);
                    continue;
                }
                this.image.method_4305(x, y, class_1011.method_24031((int)255, (int)class_1011.method_24035((int)oldValue), (int)class_1011.method_24034((int)oldValue), (int)class_1011.method_24033((int)oldValue)));
            }
        }
    }

    public void crop(TextureImage mask) {
        this.crop(mask, true);
    }

    public void crop(TextureImage mask, boolean inner) {
        int width = this.imageWidth();
        int height = this.imageHeight();
        if (mask.imageHeight() < height || mask.imageWidth() < width) {
            throw new IllegalStateException("Could not merge images because they had different dimensions");
        }
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                if (class_1011.method_24030((int)mask.image.method_4315(x, y)) != 0 != inner) continue;
                this.image.method_4305(x, y, 0);
            }
        }
        mask.close();
    }

    @FunctionalInterface
    public static interface FramePixelConsumer
    extends TriConsumer<Integer, Integer, Integer> {
        public void accept(Integer var1, Integer var2, Integer var3);
    }
}

